﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="ErrorPagehandler.aspx.vb" Inherits="knowYourSpacialty.ErrorPagehandler" %>

<%@ Import Namespace="knowYourSpacialty" %>

<script runat="server">
  Protected Sub Submit_Click(ByVal sender As Object, ByVal e As EventArgs)
    Dim arg As String = CType(sender, Button).CommandArgument
    Select Case (arg)
      Case "1"
        ' Exception handled on the Generic Error Page
        Throw New InvalidOperationException("Button 1 was clicked")
        Exit Select
      Case "2"
        ' Exception handled on the current page
        Throw New ArgumentOutOfRangeException("Button 2 was clicked")
        Exit Select
      Case "3"
        ' Exception handled by Application_Error
        Throw New Exception("Button 3 was clicked")
        Exit Select
      Case "4"
        ' Exception handled on the Http 404 Error Page
        Response.Redirect("NonexistentPage.aspx")
        Exit Select
      Case "5"
        ' Exception handled on the Http Error Page
        Response.Redirect("NonexistentPage-NoCatch.aspx")
        Exit Select
      Case "6"
        ' Exception handled on the Default Redirect Error Page
                Response.Redirect("NonexistentPage-NoCatch.aspx")
        Exit Select
    End Select
  End Sub

  Private Sub Page_Error(ByVal sender As Object, ByVal e As EventArgs)
    ' Get last error from the server
    Dim exc As Exception = Server.GetLastError

    ' Handle exceptions generated by Button 1
    If TypeOf exc Is InvalidOperationException Then
      ' Pass the error on to the Generic Error page
      Server.Transfer("GenericErrorPage.aspx", True)

    ' Handle exceptions generated by Button 2
    ElseIf TypeOf exc Is ArgumentOutOfRangeException Then
      ' Give the user some information, but
      ' stay on the default page
      Response.Write("<h2>Default Page Error</h2>" & vbLf)
      Response.Write(("<p>Provide as much information here as is " _
        & "appropriate to show to the client.</p>" & vbLf))
            Response.Write(("Return to the <a href='ErrorPageHandler.aspx'>" _
        & "Default Page</a>" & vbLf))
      ' Log the exception and notify system operators
            ExceptionUtility.LogException(exc, "DefaultPage")
            ExceptionUtility.NotifySystemOps(exc)
      ' Clear the error from the server
      Server.ClearError()
    Else
      ' Pass the error on to the default global handler
    End If
  End Sub

</script>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head id="Head1" runat="server">
  <title>Exception Handler Page</title>
</head>
<body>
  <form id="form1" runat="server">
  <div>
    <h2>
      Default Page</h2>
    <p>
      Click this button to create an InvalidOperationException.<br />
      Page_Error will catch this and redirect to 
        GenericErrorPage.aspx.<br />
      <asp:Button ID="Submit1" runat="server" 
        CommandArgument="1" OnClick="Submit_Click"
        Text="Button 1" />
    </p>
    <p>
      Click this button to create an ArgumentOutOfRangeException.<br />
      Page_Error will catch this and handle the error.<br />
      <asp:Button ID="Submit2" runat="server" 
        CommandArgument="2" OnClick="Submit_Click"
        Text="Button 2" />
    </p>
    <p>
      Click this button to create a generic Exception.<br />
      Application_Error will catch this and handle the error.<br />
      <asp:Button ID="Submit3" runat="server" 
        CommandArgument="3" OnClick="Submit_Click"
        Text="Button 3" />
    </p>
    <p>
      Click this button to create an HTTP 404 (not found) error.<br />
      Application_Error will catch this 
      and redirect to HttpErrorPage.aspx.<br />
      <asp:Button ID="Submit4" runat="server" 
        CommandArgument="4" OnClick="Submit_Click"
        Text="Button 4" />
    </p>
    <p>
      Click this button to create an HTTP 404 (not found) error.<br />
      Application_Error will catch this but will not take any action on it, 
      and ASP.NET will redirect to Http404ErrorPage.aspx. 
      The original exception object will not be available.<br />
      <asp:Button ID="Submit5" runat="server" 
        CommandArgument="5" OnClick="Submit_Click"
        Text="Button 5" />
    </p>
    <p>
      Click this button to create an HTTP 400 (invalid url) error.<br />
      Application_Error will catch this but will not take any action on it,
      and ASP.NET will redirect to DefaultRedirectErrorPage.aspx. 
      The original exception object will not be available.<br />
      <asp:Button ID="Button1" runat="server" 
        CommandArgument="6" OnClick="Submit_Click"
        Text="Button 6" />
    </p>
  </div>
  </form>
</body>
</html>