<?php
function calculateArabicScore($childPrefix) {
    $score = 0;
    for ($i = 1; $i <= 8; $i++) {
        if ($_POST["Q30_{$i}{$childPrefix}"] == 1) {
            $score++;
        }
    }
    return $score;
}

function calculateEnglishScore($childPrefix) {
    $score = 0;
    for ($i = 1; $i <= 8; $i++) {
        if ($_POST["Q31_{$i}{$childPrefix}"] == 1) {
            $score++;
        }
    }
    return $score;
}

function getFormData($formID) {
    global $conn;
    
    $data = [];
    
    // Get basic form data
    $sql = "SELECT * FROM basicqualityforms WHERE FormID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $formID);
    $stmt->execute();
    $data['basic'] = $stmt->get_result()->fetch_assoc();
    
    // Get teachers data
    $sql = "SELECT * FROM teacherssection_1 WHERE FormID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $formID);
    $stmt->execute();
    $data['teachers'] = $stmt->get_result()->fetch_assoc();
    
    // Get activities data
    $sql = "SELECT * FROM activitiessection_2 WHERE FormID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $formID);
    $stmt->execute();
    $data['activities'] = $stmt->get_result()->fetch_assoc();
    
    // Get children evaluation data
    $sql = "SELECT * FROM childrenevaluation_4 WHERE FormID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $formID);
    $stmt->execute();
    $data['evaluation'] = $stmt->get_result()->fetch_assoc();
    
    // Get direct assessment data
    $sql = "SELECT * FROM directassessment_5 WHERE FormID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $formID);
    $stmt->execute();
    $data['assessment'] = $stmt->get_result()->fetch_assoc();
    
    return $data;
}
?>