<?php
session_start();
include 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate required session variables
    if (!isset($_SESSION['school_id'])) {
        $_SESSION['error'] = "يجب البدء من صفحة البيانات العامة أولاً";
        header("Location: general.php");
        exit;
    }

    try {
        // Get values from form with proper validation
        $q18 = isset($_POST['Q18']) ? (int)$_POST['Q18'] : 0;
        $q19 = isset($_POST['Q19']) ? (int)$_POST['Q19'] : 0;
        $q20 = isset($_POST['Q20']) ? (int)$_POST['Q20'] : 0;
        $q21 = isset($_POST['Q21']) ? (int)$_POST['Q21'] : 0;
        $q22_1 = isset($_POST['Q22_1']) ? (int)$_POST['Q22_1'] : 0;
        $q22_2 = isset($_POST['Q22_2']) ? (int)$_POST['Q22_2'] : 0;
        $q23 = isset($_POST['Q23']) ? (int)$_POST['Q23'] : 0;
        $q24 = isset($_POST['Q24']) ? (int)$_POST['Q24'] : 0;
        $q25 = isset($_POST['Q25']) ? (int)$_POST['Q25'] : 0;

        // Handle Q26 checkboxes - select first issue if multiple selected
        $q26_value = isset($_POST['Q26_issues'][0]) ? $_POST['Q26_issues'][0] : null;

        $SchoolID = $_SESSION['school_id'];

        $sql = "INSERT INTO facilitiessection_3(
            SchoolID,
            SafeSeats18,
            SuitableDesks19,
            ActivitySpace20,
            OutdoorSpaces21,
            ToiletFacilities22_1,
            RunningWater22_2,
            HygieneMaterials23,
            HandWashing24,
            DrinkingWater25,
            SafetyIssues26    
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("فشل إعداد الاستعلام: " . $conn->error);
        }

        $stmt->bind_param("iiiiiiiiiis", 
            $SchoolID,
            $q18, $q19, $q20, $q21, $q22_1, 
            $q22_2, $q23, $q24, $q25, $q26_value);

        if ($stmt->execute()) {
            $_SESSION['success'] = "تم حفظ بيانات المرافق بنجاح";
            header("Location: evaluation.php");
            exit;
        } else {
            throw new Exception("فشل في تنفيذ الاستعلام: " . $stmt->error);
        }
    } catch (Exception $e) {
        error_log("Error in save_facilities.php: " . $e->getMessage());
        $_SESSION['error'] = "حدث خطأ أثناء حفظ البيانات: " . $e->getMessage();
        header("Location: facilities.php");
        exit;
    }
} else {
    $_SESSION['error'] = "الطلب غير صالح";
    header("Location: facilities.php");
    exit;
}