<?php
// save_teachers.php - Complete working version

// Start session and include config
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require __DIR__ . '/config.php';

// Verify POST request
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    $_SESSION['error'] = "الطلب غير صالح";
    header("Location: teachers.php");
    exit;
}

// Check required session variables
if (!isset($_SESSION['user_id'])) {
    $_SESSION['error'] = "يجب تسجيل الدخول أولاً";
    header("Location: login.php");
    exit;
}

if (!isset($_SESSION['current_form_id'])) {
    $_SESSION['error'] = "لم يتم العثور على نموذج أساسي، يرجى البدء من صفحة البيانات العامة";
    header("Location: general.php");
    exit;
}

if (!isset($_SESSION['school_id'])) {
    $_SESSION['error'] = "لم يتم تحديد مدرسة";
    header("Location: general.php");
    exit;
}

// Validate and sanitize all inputs
$teacher1Data = [
    'Q1' => isset($_POST['Teacher1Q1']) ? (int)$_POST['Teacher1Q1'] : 0,
    'Q2' => isset($_POST['Teacher1Q2']) ? (int)$_POST['Teacher1Q2'] : 0,
    'EducationLevel3' => isset($_POST['Teacher1EducationLevel3']) ? (int)$_POST['Teacher1EducationLevel3'] : 0,
    'Specialization4' => isset($_POST['Teacher1Specialization4']) ? (int)$_POST['Teacher1Specialization4'] : 0,
    'Experience5' => isset($_POST['Teacher1Experience5']) ? (int)$_POST['Teacher1Experience5'] : 0,
    'Training6' => isset($_POST['Teacher1Training6']) ? (int)$_POST['Teacher1Training6'] : 0,
    'TrainingTopics7' => isset($_POST['Teacher1TrainingTopics7']) ? (int)$_POST['Teacher1TrainingTopics7'] : 0
];

$teacher2Data = [
    'Q1' => isset($_POST['Teacher2Q1']) ? (int)$_POST['Teacher2Q1'] : 0,
    'Q2' => isset($_POST['Teacher2Q2']) ? (int)$_POST['Teacher2Q2'] : 0,
    'EducationLevel3' => isset($_POST['Teacher2EducationLevel3']) ? (int)$_POST['Teacher2EducationLevel3'] : 0,
    'Specialization4' => isset($_POST['Teacher2Specialization4']) ? (int)$_POST['Teacher2Specialization4'] : 0,
    'Experience5' => isset($_POST['Teacher2Experience5']) ? (int)$_POST['Teacher2Experience5'] : 0,
    'Training6' => isset($_POST['Teacher2Training6']) ? (int)$_POST['Teacher2Training6'] : 0,
    'TrainingTopics7' => isset($_POST['Teacher2TrainingTopics7']) ? (int)$_POST['Teacher2TrainingTopics7'] : 0
];

try {
    // Prepare SQL statement (CORRECTED)
    $sql = "INSERT INTO teacherssection_1 (
        FormID, SchoolID,
        Teacher1Q1, Teacher1Q2, Teacher1EducationLevel3, Teacher1Specialization4, 
        Teacher1Experience5, Teacher1Training6, Teacher1TrainingTopics7,
        Teacher2Q1, Teacher2Q2, Teacher2EducationLevel3, Teacher2Specialization4,
        Teacher2Experience5, Teacher2Training6, Teacher2TrainingTopics7
    ) VALUES (
        ?, ?, 
        ?, ?, ?, ?, ?, ?, ?, 
        ?, ?, ?, ?, ?, ?, ?
    )"; // 16 placeholders

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("فشل إعداد الاستعلام: " . $conn->error);
    }

    // Bind parameters (16 parameters)
    $bound = $stmt->bind_param(
        "iiiiiiiiiiiiiiii", // 16 'i's
        $_SESSION['current_form_id'],
        $_SESSION['school_id'],
        $teacher1Data['Q1'],
        $teacher1Data['Q2'],
        $teacher1Data['EducationLevel3'],
        $teacher1Data['Specialization4'],
        $teacher1Data['Experience5'],
        $teacher1Data['Training6'],
        $teacher1Data['TrainingTopics7'],
        $teacher2Data['Q1'],
        $teacher2Data['Q2'],
        $teacher2Data['EducationLevel3'],
        $teacher2Data['Specialization4'],
        $teacher2Data['Experience5'],
        $teacher2Data['Training6'],
        $teacher2Data['TrainingTopics7']
    );

    if (!$bound) {
        throw new Exception("فشل ربط المعاملات: " . $stmt->error);
    }

    // Execute query
    if (!$stmt->execute()) {
        throw new Exception("فشل تنفيذ الاستعلام: " . $stmt->error);
    }

    // Success - redirect to next page
    $_SESSION['success'] = "تم حفظ بيانات المعلمات بنجاح";
    header("Location: activities.php");
    exit;

} catch (Exception $e) {
    // Log error
    error_log("Save Teachers Error [" . date('Y-m-d H:i:s') . "]: " . $e->getMessage());
    
    // Show error to user
    $_SESSION['error'] = "حدث خطأ أثناء حفظ البيانات: " . $e->getMessage();
    header("Location: teachers.php");
    exit;
}
?>