<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>لوحة إدارة الجودة</title>
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f4f6f9;
            padding: 30px;
            text-align: center;
        }
        .container {
            background: white;
            padding: 30px;
            margin: auto;
            width: 90%;
            border-radius: 15px;
            box-shadow: 0 0 10px #ccc;
        }
        h1 {
            color: #333;
        }
        .btn {
            background-color: #007bff;
            color: white;
            padding: 15px 30px;
            border: none;
            font-size: 18px;
            margin: 10px;
            border-radius: 8px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 12px;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        .message {
            margin-top: 20px;
            font-size: 18px;
            color: green;
        }
        .stats {
            margin-top: 20px;
            font-size: 20px;
            color: #333;
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>لوحة تحكم إدارة الجودة</h1>

        <form method="post">
            <button class="btn" name="update">تحديث الحالة إلى "مكتمل"</button>
            <button class="btn" name="view">عرض المطبقين الذين اكتملت بياناتهم</button>
        </form>

        <?php
        include 'config.php';

        // زر التحديث
        if (isset($_POST['update'])) {
            $sql = "UPDATE basicqualityforms bqf
                    SET bqf.Status = 'مكتمل'
                    WHERE EXISTS (
                        SELECT 1
                        FROM schools s
                        INNER JOIN teacherssection_1 t1 ON bqf.SchoolID = t1.SchoolID
                        INNER JOIN activitiessection_2 a2 ON bqf.SchoolID = a2.SchoolID
                        INNER JOIN facilitiessection_3 f3 ON bqf.SchoolID = f3.SchoolID
                        INNER JOIN childrenevaluation_4 c4 ON bqf.SchoolID = c4.SchoolID
                        INNER JOIN directassessment_5 d5 ON bqf.SchoolID = d5.SchoolID
                        WHERE s.SchoolID = bqf.SchoolID
                    )";

            if ($conn->query($sql) === TRUE) {
                echo "<div class='message'>✔️ تم تحديث الحالة إلى مكتمل بنجاح</div>";
            } else {
                echo "<div class='message' style='color:red;'>❌ خطأ أثناء التحديث: " . $conn->error . "</div>";
            }
        }

        // عرض الإحصائيات
        $count_query = "SELECT 
                            COUNT(*) AS total, 
                            SUM(CASE WHEN Status = 'مكتمل' THEN 1 ELSE 0 END) AS completed 
                        FROM basicqualityforms";
        $result = $conn->query($count_query);
        if ($result && $row = $result->fetch_assoc()) {
            $total = $row['total'];
            $completed = $row['completed'];
            $percent = $total > 0 ? round(($completed / $total) * 100, 2) : 0;
            echo "<div class='stats'>عدد المدارس المكتملة: <strong>$completed</strong> من أصل <strong>$total</strong> مدرسة — نسبة الإنجاز: <strong>$percent%</strong></div>";
        }

        // زر العرض
        if (isset($_POST['view'])) {
            $sql = "SELECT 
                        bqf.userName,
                        bqf.SchoolID,
                        s.SchoolName
                    FROM 
                        basicqualityforms bqf
                    INNER JOIN schools s ON bqf.SchoolID = s.SchoolID
                    INNER JOIN teacherssection_1 t1 ON bqf.SchoolID = t1.SchoolID
                    INNER JOIN activitiessection_2 a2 ON bqf.SchoolID = a2.SchoolID
                    INNER JOIN facilitiessection_3 f3 ON bqf.SchoolID = f3.SchoolID
                    INNER JOIN childrenevaluation_4 c4 ON bqf.SchoolID = c4.SchoolID
                    INNER JOIN directassessment_5 d5 ON bqf.SchoolID = d5.SchoolID";

            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                echo "<table>
                        <tr>
                            <th>اسم المطبق</th>
                            <th>كود المدرسة</th>
                            <th>اسم المدرسة</th>
                        </tr>";
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>" . htmlspecialchars($row['userName']) . "</td>
                            <td>" . $row['SchoolID'] . "</td>
                            <td>" . $row['SchoolName'] . "</td>
                        </tr>";
                }
                echo "</table>";
            } else {
                echo "<div class='message'>لا توجد نتائج حالياً.</div>";
            }
        }

        $conn->close();
        ?>
    </div>
</body>
</html>
