<?php
include 'config.php';

// Start with destroying any existing session
session_start();
session_unset();    // Unset all session variables
session_destroy();  // Destroy the session
session_start();    // Start a fresh session

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verify POST data
if (empty($_POST['nationalID'])) {
    $_SESSION['error'] = "الرقم القومي مطلوب";
    header("Location: login.php");
    exit();
}

$nationalID = trim($_POST['nationalID']);

try {
    $sql = "SELECT * FROM users WHERE NationalID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $nationalID);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        
        // Set all session variables including FullName as username
        $_SESSION['user_id'] = $user['UserID'];
        $_SESSION['fullname'] = $user['FullName'];
        $_SESSION['username'] = $user['FullName']; // Using FullName as username
        $_SESSION['governorate_id'] = $user['GovernorateID'];
        $_SESSION['directorate_id'] = $user['DirectorateID'];
        $_SESSION['logged_in'] = true;
        
        // Regenerate session ID for security
        session_regenerate_id(true);
        
        header("Location: general.php");
        exit();
    } else {
        $_SESSION['error'] = "المستخدم غير مسجل!";
        header("Location: login.php");
        exit();
    }
} catch (Exception $e) {
    error_log("Login error: " . $e->getMessage());
    $_SESSION['error'] = "حدث خطأ في النظام. الرجاء المحاولة لاحقاً.";
    header("Location: login.php");
    exit();
}