<?php
include 'config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (isset($_SESSION['errors'])) {
    echo '<div class="alert alert-danger">';
    foreach ($_SESSION['errors'] as $error) {
        echo "<p>$error</p>";
    }
    echo '</div>';
    unset($_SESSION['errors']);
}

?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل مستخدم جديد - نظام متابعة جودة رياض الأطفال</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background: url('login.jpg') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .register-container {
            max-width: 700px;
            margin: 2rem auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        
        .register-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        
        .register-header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
            font-size: 1.5rem;
        }
        
        .register-header p {
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 0;
            font-size: 0.9rem;
        }
        
        .register-body {
            padding: 2rem;
        }
        
        .form-control, .form-select {
            padding: 12px 15px;
            border-radius: 5px;
            border: 1px solid #ddd;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-register {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 12px;
            font-weight: 500;
            width: 100%;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .btn-register:hover {
            background-color: #246b66;
            transform: translateY(-2px);
        }
        
        .register-footer {
            text-align: center;
            padding: 1rem;
            border-top: 1px solid #eee;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        
        .logo img {
            max-height: 70px;
            margin: 0 10px;
        }
        
        @media (max-width: 768px) {
            .register-container {
                margin: 1rem;
            }
            
            .register-header h1 {
                font-size: 1.3rem;
            }
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="register-header">
            <div class="logo">
                <img src="media/nceee.png" alt="Logo">
                <img src="media/wezara.png" alt="Logo">
            </div>
            <h1><i class="fas fa-child"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <p>المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
        
        <div class="register-body">
            <h2 class="text-center mb-4"><i class="fas fa-user-plus"></i> تسجيل مستخدم جديد</h2>
            <form action="register_process.php" method="POST">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="fullName" class="form-label">الاسم الرباعي</label>
                        <input type="text" class="form-control" id="fullName" name="fullName" required>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="nationalID" class="form-label">الرقم القومي</label>
                        <input type="text" class="form-control" id="nationalID" name="nationalID" required maxlength="14">
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="governorate" class="form-label">(جهة العمل) المحافظة</label>
                        <select id="governorate" name="governorate" class="form-select" required>
                            <option value="">اختر المحافظة</option>
                            <?php
                            $sql = "SELECT * FROM governorates";
                            $result = $conn->query($sql);
                            while ($row = $result->fetch_assoc()) {
                                echo "<option value='{$row['GovernorateID']}'>{$row['GovernorateName']}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="directorate" class="form-label">الإدارة التعليمية (جهة العمل)</label>
                        <select id="directorate" name="directorate" class="form-select" required disabled>
                            <option value="">اختر الإدارة التعليمية</option>
                        </select>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني (اختياري)</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">رقم الهاتف</label>
                        <input type="tel" class="form-control" id="phone" name="phone">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-register mt-3">
                    <i class="fas fa-user-plus"></i> تسجيل
                </button>
            </form>
        </div>
        
        <div class="register-footer">
            <p>لديك حساب بالفعل؟ <a href="login.php" class="text-decoration-none">تسجيل الدخول</a></p>
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    
    <script>
        document.getElementById('governorate').addEventListener('change', function() {
            const directorateSelect = document.getElementById('directorate');
            directorateSelect.innerHTML = '<option value="">اختر الإدارة التعليمية</option>';
            directorateSelect.disabled = !this.value;
            
            if (this.value) {
                fetch('get_directorates.php?gov_id=' + this.value)
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(dir => {
                            const option = document.createElement('option');
                            option.value = dir.DirectorateID;
                            option.textContent = dir.DirectorateName;
                            directorateSelect.appendChild(option);
                        });
                        directorateSelect.disabled = false;
                    });
            }
        });
    </script>
</body>
</html>