<?php
session_start();
// include 'config.php'; // Uncomment if you have a config.php

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مرافق الروضة - نظام متابعة جودة رياض الأطفال</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --accent-color: #f8b400;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
            --success-color: #4caf50; 
            --info-color: #00bcd4;
            --warning-color: #ff9800;
            --danger-color: #f44336;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .header h2 {
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 0;
        }
        
        .container {
            max-width: 1200px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #dee2e6;
            margin-bottom: 1.5rem;
        }
        
        .nav-tabs .nav-link {
            border: 1px solid #dee2e6;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-left: 5px; 
            background: #f8f9fa;
            color: var(--dark-color);
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .nav-tabs .nav-link.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
        
        .tab-content {
            padding: 25px;
            border: 1px solid #dee2e6;
            border-top: none;
            background: white;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 25px;
            background-color: white;
            border-radius: 8px;
            border-left: 5px solid var(--primary-color); 
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .section-title { 
            color: var(--primary-color);
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            background: white;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        th, td {
            border: 1px solid #e0e0e0;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: var(--primary-color); 
            color: white;
            font-weight: 500;
        }
        
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tr:hover {
            background-color: #f1f1f1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            font-weight: 500;
            color: var(--dark-color);
            margin-bottom: 8px;
            display: block;
        }
        
        .radio-group { 
            display: flex;
            gap: 20px;
            margin: 15px 0;
            flex-wrap: wrap;
        }

        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-weight: normal;
        }

        input[type="text"],
        input[type="number"],
        input[type="email"],
        input[type="password"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-custom-save { 
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: white;
            padding: 12px 30px;
            font-size: 18px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-custom-save:hover {
            background-color: #246b66;
            border-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
         .btn-custom-save:active {
            transform: translateY(0);
        }

        .welcome-message {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            border-left: 4px solid var(--accent-color); 
        }
        .welcome-message h3 {
            color: var(--dark-color);
            margin-bottom: 0;
            font-weight: 600;
        }

        .icon { 
            margin-left: 8px; 
        }

        /* Responsive adjustments from New.php */
        @media (max-width: 992px) {
            .nav-tabs .nav-link { padding: 10px 15px; font-size: 14px; }
            .section { padding: 20px; }
            th, td { padding: 10px; font-size: 14px; }
        }
        
        @media (max-width: 768px) {
            .header { padding: 1.5rem 0; }
            .header h1 { font-size: 1.8rem; }
            .header h2 { font-size: 1.3rem; }
            .nav-tabs { flex-wrap: nowrap; overflow-x: auto; white-space: nowrap; -webkit-overflow-scrolling: touch; padding-bottom: 5px; }
            .nav-tabs .nav-link { padding: 8px 12px; font-size: 13px; }
            .tab-content { padding: 15px; }
            .section { padding: 15px; }
            table { display: block; overflow-x: auto; white-space: nowrap; }
            .radio-group { gap: 10px; }
        }
        
        @media (max-width: 576px) {
            .header h1 { font-size: 1.5rem; }
            .header h2 { font-size: 1.1rem; }
            .btn-custom-save { width: 100%; padding: 12px; }
            .radio-group { flex-direction: column; gap: 8px; }
        }
        .btn { 
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-primary { 
            background-color: var(--primary-color);
            color: white;
            border: 1px solid var(--primary-color);
        }
        .btn-primary:hover {
            background-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            color: white;
        }
        .btn-secondary { 
             background-color: var(--light-color);
             color: var(--dark-color);
             border: 1px solid var(--primary-color); 
        }
        .btn-secondary:hover{
            background-color: #e9ecef;
        }
        .btn-lg {
            padding: 12px 30px;
            font-size: 1.1rem;
        }
        .nav-buttons { 
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        /* Ensure checkbox column is not too wide */
        td input[type="checkbox"] {
            margin: 0 auto; /* Center checkbox */
        }
        /* Make the Yes/No columns for radio buttons narrower if needed */
        table td:nth-child(3), table td:nth-child(4) {
             /* width: 10%; /* Adjust as needed */
        }
        /* Specific for Q26 checkbox layout */
        #q26_table td:first-child { width: 5%; } /* For # */
        #q26_table td:nth-child(2) { text-align: right; width: 85%;} /* For question text */
        #q26_table td:last-child { width: 10%; } /* For checkbox */


    </style>
</head>
<body>

    <div class="header text-center">
        <div class="container">
            <h1><i class="fas fa-child icon"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <h2><i class="fas fa-map-marker-alt icon"></i> في جمهورية مصر العربية</h2>
            <p><i class="fas fa-university icon"></i> المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
    </div>

    <div class="container py-3">
        <?php if (isset($_SESSION['fullname'])): ?>
        <div class="welcome-message">
            <h3><i class="fas fa-user-circle icon"></i> مرحبًا، <?php echo htmlspecialchars($_SESSION['fullname']); ?></h3>
        </div>
        <?php
// Display success/error messages
if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger">
        <?= $_SESSION['error']; unset($_SESSION['error']); ?>
    </div>
<?php endif; ?>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success">
        <?= $_SESSION['success']; unset($_SESSION['success']); ?>
    </div>
<?php endif; ?>
        <?php endif; ?>
        
        <ul class="nav nav-tabs" id="formTabs">
            <li class="nav-item">
                <a class="nav-link" href="general.php">
                    <i class="fas fa-info-circle"></i> البيانات العامة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="teachers.php"> 
                    <i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="activities.php">
                    <i class="fas fa-book-open"></i> أنشطة التعليم والتعلم
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="facilities.php"> <i class="fas fa-school"></i> مرافق الروضة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="evaluation.php">
                    <i class="fas fa-clipboard-check"></i> تقويم الأطفال من وجهة نظر المعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="evaluation_5.php">
                    <i class="fas fa-user-tie"></i> تقييم الأطفال من قبل القائم بالتطبيق
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="manual.php">
                     <i class="fas fa-book"></i> دليل المستخدم
                </a>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade show active" id="facilities-content">
                 <form action="save_facilities.php" method="POST"> <input type="hidden" name="SchoolID" value="<?php echo htmlspecialchars($currentSchoolID); ?>">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-building icon"></i> المحور الثالث: مرافق الروضة وعوامل الأمن والسلامة</h2>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th>نعم</th>
                                        <th>لا</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>18</td>
                                        <td>هل جميع الأطفال لديهم مقاعد آمنة مناسبة لأحجامهم؟</td>
                                        <td><input type="radio" name="Q18" value="2" required></td>
                                        <td><input type="radio" name="Q18" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>19</td>
                                        <td>هل جميع الأطفال لديهم مكاتب أو مناضد مناسبة لأحجامهم وبها مساحة كافية لتأدية عملهم؟</td>
                                        <td><input type="radio" name="Q19" value="2" required></td>
                                        <td><input type="radio" name="Q19" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>20</td>
                                        <td>هل توجد مساحة للأنشطة لجميع الأطفال تكفي لقيامهم من مكاتبهم والاشتراك في الأنشطة التي تتم في قاعة النشاط؟</td>
                                        <td><input type="radio" name="Q20" value="2" required></td>
                                        <td><input type="radio" name="Q20" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>21</td>
                                        <td>هل يوجد أماكن آمنة للأطفال لقيامهم بأنشطة خارج القاعة، ولكن داخل الروضة (مثل حجرات الأنشطة "المخصصة مثلاً للموسيقى والتمثيل"، وصالة الألعاب الرياضية، والحديقة، وملعب الروضة..... إلخ)</td>
                                        <td><input type="radio" name="Q21" value="2" required></td>
                                        <td><input type="radio" name="Q21" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>22</td>
                                        <td style="text-align: right;"><strong>المرافق الصحية:</strong></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align: right;">22-1- هل توجد مرافق لدورات مياه صحية للأطفال من الجنسين لكلا من الذكور والإناث؟</td>
                                        <td><input type="radio" name="Q22_1" value="2" required></td>
                                        <td><input type="radio" name="Q22_1" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td style="text-align: right;">22-2- هل توجد مياه جارية ونظيفة؟</td>
                                        <td><input type="radio" name="Q22_2" value="2" required></td>
                                        <td><input type="radio" name="Q22_2" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>23</td>
                                        <td>هل هناك صابون ومناديل ومواد مطهرة؟</td>
                                        <td><input type="radio" name="Q23" value="2" required></td>
                                        <td><input type="radio" name="Q23" value="1" required></td>
                                    </tr>
                                    <tr>
                                        <td>24</td>
                                        <td>إذا كانت الإجابة بنعم، هل يغسل جميع الأطفال أيديهم بالماء والصابون بعد استخدام المرحاض؟</td>
                                        <td><input type="radio" name="Q24" value="2" data-depends-on="Q23" data-depends-value="2" required></td>
                                        <td><input type="radio" name="Q24" value="1" data-depends-on="Q23" data-depends-value="2" required></td>
                                        </tr>
                                    <tr>
                                        <td>25</td>
                                        <td>هل يتوافر للأطفال مصدر صحي لمياه الشرب النظيفة؟</td>
                                        <td><input type="radio" name="Q25" value="2" required></td>
                                        <td><input type="radio" name="Q25" value="1" required></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4 class="section-title mt-4"><i class="fas fa-shield-alt icon"></i> 26- هل تتوافر عوامل الأمن والسلامة بمبنى الروضة ومرافقها؟ </h4>
                        <p class="text-muted">(اختر كل ما ينطبق من المشكلات المرصودة. إذا لم توجد مشكلات، اختر "لا شيء")</p>
                        <div class="table-responsive">
                            <table class="table-bordered" id="q26_table">
                                 <thead>
                                    <tr>
                                        <th style="width:5%;">#</th>
                                        <th style="width:85%; text-align:right;">المشكلة المرصودة</th>
                                        <th style="width:10%;">حدد</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>أرضيات مكسورة أو غير مستوية.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="1"></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>الكراسي أو المناضد مكسورة.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="2"></td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>يوجد تسرب بالسقف أو ثقوب في السقف.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="3"></td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>نوافذ أو أبواب مكسورة.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="4"></td>
                                    </tr>
                                    <tr>
                                        <td>5</td>
                                        <td>الإضاءة الطبيعية غير كافية.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="5"></td>
                                    </tr>
                                    <tr>
                                        <td>6</td>
                                        <td>التهوية غير كافية.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="6"></td>
                                    </tr>
                                    <tr>
                                        <td>7</td>
                                        <td>ملاعب صخرية بها مهملات أو حفر مفتوحة.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="7"></td>
                                    </tr>
                                    <tr>
                                        <td>8</td>
                                        <td>عدم وجود سور حول مبنى المدرسة.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="8"></td>
                                    </tr>
                                    <tr>
                                        <td>9</td>
                                        <td>المدرسة بالقرب من الطرق الرئيسية.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="9"></td>
                                    </tr>
                                    <tr>
                                        <td>10</td>
                                        <td>حالات أخرى من المحتمل أن تسبب إصابة للأطفال.</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="10"></td>
                                    </tr>
                                    <tr>
                                        <td>11</td>
                                        <td><strong>لا شيء</strong> (لا توجد أي من المشكلات المذكورة أعلاه).</td>
                                        <td><input type="checkbox" name="Q26_issues[]" value="11" id="q26_no_issues"></td>
                                    </tr>
                                </tbody>
                            </table>
                             <div id="q26_validation_message" class="text-danger mt-2" style="display:none;">يجب تحديد خيار واحد على الأقل من قائمة عوامل الأمن والسلامة، أو تحديد "لا شيء".</div>
                        </div>
                    </div>
                    <div class="text-center mt-4 mb-5">
                         <button type="submit" class="btn btn-primary btn-lg btn-custom-save">
                             <i class="fas fa-save"></i> حفظ بيانات المرافق
                         </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="nav-buttons">
            <button type="button" class="btn btn-secondary prev-tab-custom">
                <i class="fas fa-arrow-right"></i> السابق
            </button>
            <button type="button" class="btn btn-primary next-tab-custom">
                <i class="fas fa-arrow-left"></i> التالي
            </button>
        </div>

    </div>
      
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = Array.from(document.querySelectorAll('.nav-tabs .nav-link'));
            const currentActiveTabLink = document.querySelector('.nav-tabs .nav-link.active');
            let currentTabIndex = tabs.findIndex(tab => tab.classList.contains('active'));

            const nextBtn = document.querySelector('.next-tab-custom');
            const prevBtn = document.querySelector('.prev-tab-custom');

            function updateButtonVisibility() {
                if (prevBtn) prevBtn.style.display = currentTabIndex === 0 ? 'none' : 'inline-flex';
                if (nextBtn) nextBtn.style.display = currentTabIndex === tabs.length - 1 ? 'none' : 'inline-flex';
            }

            if (nextBtn) {
                nextBtn.addEventListener('click', function() {
                    if (currentTabIndex < tabs.length - 1) {
                        const nextTabLink = tabs[currentTabIndex + 1];
                        if(nextTabLink) window.location.href = nextTabLink.href;
                    }
                });
            }

            if (prevBtn) {
                prevBtn.addEventListener('click', function() {
                    if (currentTabIndex > 0) {
                       const prevTabLink = tabs[currentTabIndex - 1];
                       if(prevTabLink) window.location.href = prevTabLink.href;
                    }
                });
            }
            
            updateButtonVisibility();

            // Q24 dependency on Q23
            const q23Radios = document.querySelectorAll('input[name="Q23"]');
            const q24Radios = document.querySelectorAll('input[name="Q24"]');

            function toggleQ24(q23Value) {
                const enableQ24 = (q23Value === "2"); // Enable if Q23 is "نعم"
                q24Radios.forEach(radio => {
                    radio.disabled = !enableQ24;
                    if (!enableQ24) {
                        radio.checked = false;
                        // If you want a default for Q24 when disabled, set it here
                        // For example, if Q24 has a "لا ينطبق" option with value "0":
                        // if (radio.value === "0") radio.checked = true; 
                    }
                });
            }
            q23Radios.forEach(radio => {
                radio.addEventListener('change', function() {
                    toggleQ24(this.value);
                });
                 // Initial state
                if (radio.checked) {
                    toggleQ24(radio.value);
                }
            });
             // Initial state if no Q23 is checked (assuming default "لا" for Q23 implies Q24 is disabled)
            if (!document.querySelector('input[name="Q23"]:checked')) {
                toggleQ24("1"); // Simulate Q23 "لا"
            }


            // Q26 checkbox logic: if "لا شيء" is checked, uncheck others. If others checked, uncheck "لا شيء".
            const q26Checkboxes = document.querySelectorAll('input[name="Q26_issues[]"]');
            const q26NoIssuesCheckbox = document.getElementById('q26_no_issues');

            q26Checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    if (this.id === 'q26_no_issues' && this.checked) {
                        q26Checkboxes.forEach(cb => {
                            if (cb.id !== 'q26_no_issues') cb.checked = false;
                        });
                    } else if (this.checked && this.id !== 'q26_no_issues') {
                        if (q26NoIssuesCheckbox) q26NoIssuesCheckbox.checked = false;
                    }
                });
            });

            // Form submission validation and save button state
            const facilitiesForm = document.querySelector('form[action="save_facilities.php"]');
            if (facilitiesForm) {
                facilitiesForm.addEventListener('submit', function(e) {
                    // Q26 validation: at least one checkbox must be checked
                    const q26Checked = Array.from(q26Checkboxes).some(cb => cb.checked);
                    const q26ValidationMessage = document.getElementById('q26_validation_message');

                    if (!q26Checked) {
                        if (q26ValidationMessage) q26ValidationMessage.style.display = 'block';
                        e.preventDefault(); // Prevent submission
                        e.stopPropagation();
                         alert('بالنسبة للسؤال 26، يرجى تحديد واحدة على الأقل من المشكلات المرصودة، أو تحديد "لا شيء".');
                         this.classList.add('was-validated'); // Show other Bootstrap validation
                        return; // Stop further processing
                    } else {
                        if (q26ValidationMessage) q26ValidationMessage.style.display = 'none';
                    }


                    // General form validity check
                    if (!this.checkValidity()) {
                        e.preventDefault();
                        e.stopPropagation();
                        this.classList.add('was-validated'); // Bootstrap validation styles
                        alert('يرجى ملء جميع الحقول المطلوبة بشكل صحيح.');
                    } else {
                        const saveButton = this.querySelector('.btn-custom-save');
                        if (saveButton) {
                            const originalText = saveButton.innerHTML;
                            saveButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الحفظ...';
                            saveButton.disabled = true;
                            // Form will submit normally.
                        }
                    }
                });
            }
        });
    </script>

</body>
</html>