<?php
include 'config.php';
header('Content-Type: text/html; charset=utf-8');
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}


?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>البيانات العامة - نظام متابعة جودة رياض الأطفال</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --accent-color: #f8b400;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
            --success-color: #4caf50;
            --info-color: #00bcd4;
            --warning-color: #ff9800;
            --danger-color: #f44336;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .header h2 {
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 0;
        }
        
        .container {
            max-width: 1200px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #dee2e6;
            margin-bottom: 1.5rem;
        }
        
        .nav-tabs .nav-link {
            border: 1px solid #dee2e6;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-left: 5px;
            background: #f8f9fa;
            color: var(--dark-color);
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .nav-tabs .nav-link.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
        
        .tab-content {
            padding: 25px;
            border: 1px solid #dee2e6;
            border-top: none;
            background: white;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 25px;
            background-color: white;
            border-radius: 8px;
            border-left: 5px solid var(--primary-color);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            color: var(--primary-color);
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            background: white;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        th, td {
            border: 1px solid #e0e0e0;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 500;
        }
        
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tr:hover {
            background-color: #f1f1f1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            font-weight: 500;
            color: var(--dark-color);
            margin-bottom: 8px;
            display: block;
        }
        
        .radio-group {
            display: flex;
            gap: 20px;
            margin: 15px 0;
            flex-wrap: wrap;
        }
        
        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-weight: normal;
        }
        
        input[type="text"],
        input[type="number"],
        input[type="email"],
        input[type="password"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-success {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 12px 30px;
            font-size: 18px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-success:hover {
            background-color: #246b66;
            border-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .btn-success:active {
            transform: translateY(0);
        }
        
        .welcome-message {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            border-left: 4px solid var(--accent-color);
        }
        
        .welcome-message h3 {
            color: var(--dark-color);
            margin-bottom: 0;
            font-weight: 600;
        }
        
        .icon {
            margin-left: 8px;
            color: var(--primary-color);
        }
        
        .disabled-row {
            opacity: 0.6;
            pointer-events: none;
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .nav-tabs .nav-link {
                padding: 10px 15px;
                font-size: 14px;
            }
            
            .section {
                padding: 20px;
            }
            
            th, td {
                padding: 10px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 768px) {
            .header {
                padding: 1.5rem 0;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
            
            .header h2 {
                font-size: 1.3rem;
            }
            
            .nav-tabs {
                flex-wrap: nowrap;
                overflow-x: auto;
                white-space: nowrap;
                -webkit-overflow-scrolling: touch;
                padding-bottom: 5px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .tab-content {
                padding: 15px;
            }
            
            .section {
                padding: 15px;
            }
            
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            .radio-group {
                gap: 10px;
            }
        }
        
        @media (max-width: 576px) {
            .header h1 {
                font-size: 1.5rem;
            }
            
            .header h2 {
                font-size: 1.1rem;
            }
            
            .btn-success {
                width: 100%;
                padding: 12px;
            }
            
            .radio-group {
                flex-direction: column;
                gap: 8px;
            }
        }
        .btn {
    padding: 10px 20px;
    border-radius: 5px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.btn-primary {
    background-color: var(--primary-color);
    color: white;
    border: 1px solid var(--primary-color);
}

.btn-primary:hover {
    background-color: #246b66;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    color: white;
}

.btn-secondary {
    background-color: var(--light-color);
    color: var(--dark-color);
    border: 1px solid var(--primary-color);
}

.btn-secondary:hover {
    background-color: #e9ecef;
}

.btn-success {
    background-color: var(--success-color);
    color: white;
    border: 1px solid var(--success-color);
}

.btn-outline-secondary {
    background-color: transparent;
    color: var(--dark-color);
    border: 1px solid var(--secondary-color);
}

.btn-outline-secondary:hover {
    background-color: #f8f9fa;
}

.btn-link {
    background: none;
    border: none;
    color: var(--primary-color);
    padding: 0;
}

.btn-lg {
    padding: 12px 30px;
    font-size: 1.1rem;
}
    </style>
</head>
<body>

    <div class="header text-center">
        <div class="container">
            <h1><i class="fas fa-child icon"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <h2><i class="fas fa-map-marker-alt icon"></i> في جمهورية مصر العربية</h2>
            <p><i class="fas fa-university icon"></i> المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
    </div>

    <div class="container py-3">
        <div class="welcome-message">
            <h3><i class="fas fa-user-circle"></i> مرحبًا، <?php echo $_SESSION['fullname']; ?></h3>
        </div>
        <?php
// Display success/error messages
if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger">
        <?= $_SESSION['error']; unset($_SESSION['error']); ?>
    </div>
<?php endif; ?>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success">
        <?= $_SESSION['success']; unset($_SESSION['success']); ?>
    </div>
<?php endif; ?>
        <form action="save_general.php" method="POST">
            
            <!-- Tabs Navigation -->
            <ul class="nav nav-tabs" id="formTabs">
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" href="general.php">
                        <i class="fas fa-info-circle"></i> البيانات العامة
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="teachers.php">
                        <i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="activities.php">
                        <i class="fas fa-book-open"></i> أنشطة التعليم والتعلم
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="facilities.php">
                        <i class="fas fa-school"></i> مرافق الروضة
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="evaluation.php">
                        <i class="fas fa-clipboard-check"></i> تقويم الأطفال من وجهة نظر المعلمات
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="evaluation_5.php">
                        <i class="fas fa-user-tie"></i> تقييم الأطفال من قبل القائم بالتطبيق
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="manual.php">
                        <i class="fas fa-book"></i> دليل المستخدم
                    </a>
                </li>
            </ul>

            <!-- Tabs Content -->
            <div class="tab-content">
                
                <!-- General Information Tab -->
                <div class="tab-pane fade show active" id="general">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-info-circle"></i> البيانات الأساسية</h2>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="governorate"><i class="fas fa-map-marked-alt"></i> المحافظة:</label>
                                    <select id="governorate" name="governorate" class="form-select" required>
                                        <option value="">اختر المحافظة</option>
                                        <?php
                                        $sql = "SELECT * FROM governorates";
                                        $result = $conn->query($sql);
                                        while ($row = $result->fetch_assoc()) {
                                            echo "<option value='{$row['GovernorateID']}'>{$row['GovernorateName']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="directorate"><i class="fas fa-building"></i> الإدارة التعليمية:</label>
                                    <select id="directorate" name="directorate" class="form-select" required disabled>
                                        <option value="">اختر الإدارة التعليمية</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="school"><i class="fas fa-school"></i> اسم الروضة:</label>
                                    <select name="school" id="school" class="form-select" required >
                                        <option value="">اختر الروضة</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-flag"></i> تبعية الروضة:</label>
                                    <div class="radio-group">
                                        <label>
                                            <input type="radio" id="official" name="affiliation" value="1" required>
                                            رسمي
                                        </label>
                                        <label>
                                            <input type="radio" id="experimental" name="affiliation" value="2" required>
                                            تجريبي
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-tree"></i> البيئة المحيطة بالروضة:</label>
                                    <div class="radio-group">
                                        <label>
                                            <input type="radio" id="rural" name="environment" value="2" required>
                                            ريف
                                        </label>
                                        <label>
                                            <input type="radio" id="urban" name="environment" value="1" required>
                                            حضر
                                        </label>
                                        <label>
                                            <input type="radio" id="coastal" name="environment" value="3" required>
                                            ساحلية
                                        </label>
                                        <label>
                                            <input type="radio" id="desert" name="environment" value="4" required>
                                            صحراوية
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="total-teachers"><i class="fas fa-chalkboard-teacher"></i> العدد الإجمالي للمعلمات بالروضة:</label>
                                    <input type="number" id="total-teachers" name="total-teachers" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="paid-teachers"><i class="fas fa-money-bill-wave"></i> عدد المعلمات التي تتقاضى أجراً:</label>
                                    <input type="number" id="paid-teachers" name="paid-teachers" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="volunteer-teachers"><i class="fas fa-hands-helping"></i> عدد المعلمات التي لا تتقاضى أجراً:</label>
                                    <input type="number" id="volunteer-teachers" name="volunteer-teachers" class="form-control" required>
                                </div>
                            </div>
                        </div>
                    </div>
            
                    <!-- Targeted Kindergarten Data -->
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-school"></i> بيانات الروضة المستهدفة</h2>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-graduation-cap"></i> الصف:</label>
                                    <div class="radio-group">
                                        <label>
                                            <input type="radio" id="kg1" name="grade" value="1" required>
                                            KG1
                                        </label>
                                        <label>
                                            <input type="radio" id="kg2" name="grade" value="2" required>
                                            KG2
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="room-number"><i class="fas fa-door-open"></i> رقم القاعة:</label>
                                    <input type="number" id="room-number" name="room-number" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="children-count"><i class="fas fa-child"></i> عدد الأطفال في القاعة:</label>
                                    <input type="number" id="children-count" name="children-count" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="teacher1-code"><i class="fas fa-user-tie"></i> كود المعلمة (1):</label>
                                    <input type="text" id="teacher1-code" name="teacher1-code" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="teacher2-code"><i class="fas fa-user-tie"></i> كود المعلمة (2):</label>
                                    <input type="text" id="teacher2-code" name="teacher2-code" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="text-center mt-4 mb-5">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save"></i> حفظ البيانات العامة
                </button>
            </div>
            <input type="hidden" id="hiddenSchoolID" name="school_id">
        </form>
    </div>
      
    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    
    <script>
        document.getElementById('governorate').addEventListener('change', function() {
            const directorateSelect = document.getElementById('directorate');
            directorateSelect.innerHTML = '<option value="">اختر الإدارة التعليمية</option>';
            directorateSelect.disabled = !this.value;
            
            if (this.value) {
                fetch('get_directorates.php?gov_id=' + this.value)
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(dir => {
                            const option = document.createElement('option');
                            option.value = dir.DirectorateID;
                            option.textContent = dir.DirectorateName;
                            directorateSelect.appendChild(option);
                        });
                        directorateSelect.disabled = false;
                    });
            }
        });

       document.getElementById('directorate').addEventListener('change', async function() {
    const schoolSelect = document.getElementById('school');
    const loadingOption = document.createElement('option');
    loadingOption.value = '';
    loadingOption.textContent = 'جار التحميل...';
    loadingOption.disabled = true;
    loadingOption.selected = true;
    
    schoolSelect.innerHTML = '';
    schoolSelect.appendChild(loadingOption);
    schoolSelect.disabled = true;

    if (!this.value) return;

    try {
        // Add timestamp to prevent caching
        const apiUrl = `get_schools.php?directorate_id=${encodeURIComponent(this.value)}&_=${Date.now()}`;
        const response = await fetch(apiUrl);
        
        if (!response.ok) {
            throw new Error(`Server returned ${response.status} status`);
        }

        const data = await response.json();

        if (!data.success) {
            throw new Error(data.error || 'Invalid server response');
        }

        schoolSelect.innerHTML = '<option value="">اختر الروضة</option>';
        
        if (data.data && data.data.length > 0) {
            data.data.forEach(school => {
                const option = new Option(school.SchoolName, school.SchoolID);
                schoolSelect.add(option);
            });
        } else {
            schoolSelect.innerHTML = '<option value="">لا توجد نتائج</option>';
        }

        schoolSelect.disabled = false;

    } catch (error) {
        console.error('Fetch error:', error);
        const errorOption = new Option(`خطأ في التحميل: ${error.message}`, '');
        errorOption.disabled = true;
        schoolSelect.innerHTML = '';
        schoolSelect.appendChild(errorOption);
        
        // Optional: Show alert for user feedback
        alert('حدث خطأ أثناء جلب بيانات المدارس. يرجى المحاولة لاحقًا.');
    }
});
document.getElementById('school').addEventListener('change', function() {
    // Store selected school ID in hidden field and session via AJAX
    const schoolID = this.value;
    document.getElementById('hiddenSchoolID').value = schoolID;
    
    // Store in session via AJAX
    fetch('store_school_session.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'school_id=' + encodeURIComponent(schoolID)
    });
});
    </script>
</body>
</html>