<?php
include 'config.php';
if (isset($_GET['success'])) {
    echo "<script>alert('تم التسجيل بنجاح! يمكنك الآن تسجيل الدخول.');</script>";
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام متابعة جودة رياض الأطفال</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background: url('login.jpg') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .login-container {
            max-width: 500px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        
        .login-header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
            font-size: 1.5rem;
        }
        
        .login-header p {
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 0;
            font-size: 0.9rem;
        }
        
        .login-body {
            padding: 2rem;
        }
        
        .form-control {
            padding: 12px 15px;
            border-radius: 5px;
            border: 1px solid #ddd;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-login {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 12px;
            font-weight: 500;
            width: 100%;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .btn-login:hover {
            background-color: #246b66;
            transform: translateY(-2px);
        }
        
        .login-footer {
            text-align: center;
            padding: 1rem;
            border-top: 1px solid #eee;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        
        .logo img {
            max-height: 70px;
            margin: 0 10px;
        }
        
        @media (max-width: 576px) {
            .login-container {
                margin: 0 15px;
            }
            
            .login-header h1 {
                font-size: 1.3rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <div class="logo">
                <img src="media/nceee.png" alt="Logo">
                <img src="media/wezara.png" alt="Logo">
            </div>
            <h1><i class="fas fa-child"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <p>المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
        
        <div class="login-body">
            <h2 class="text-center mb-4"><i class="fas fa-sign-in-alt"></i> تسجيل الدخول</h2>
            <form action="login_process.php" method="POST">
                <div class="mb-3">
                    <label for="nationalID" class="form-label">الرقم القومي</label>
                    <input type="text" class="form-control" id="nationalID" name="nationalID" required maxlength="14">
                </div>
                
                <button type="submit" class="btn btn-login mt-3">
                    <i class="fas fa-sign-in-alt"></i> دخول
                </button>
            </form>
        </div>
        
        <div class="login-footer">
            <p>ليس لديك حساب؟ <a href="register.php" class="text-decoration-none">إنشاء حساب جديد</a></p>
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
</body>
</html>