<?php
// Start secure session
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_lifetime' => 86400,
        'cookie_secure' => isset($_SERVER['HTTPS']),
        'cookie_httponly' => true,
        'cookie_samesite' => 'Lax' // Changed from Strict to Lax for better compatibility
    ]);
}

// Verify authentication
if (!isset($_SESSION['logged_in']) || !isset($_SESSION['user_id'])) {
    $_SESSION['error'] = "يجب تسجيل الدخول أولاً";
    header("Location: login.php");
    exit();
}

require __DIR__ . '/config.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verify POST request
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    $_SESSION['error'] = "الطلب غير صالح";
    header("Location: general.php");
    exit();
}

// Validate all required POST fields
$requiredFields = [
    'school_id', 'affiliation', 'environment', 'total-teachers', 
    'paid-teachers', 'volunteer-teachers', 'grade', 'room-number',
    'children-count', 'teacher1-code'
];

foreach ($requiredFields as $field) {
    if (!isset($_POST[$field])) {
        $_SESSION['error'] = "حقل مطلوب مفقود: " . $field;
        header("Location: general.php");
        exit();
    }
}

// Get and sanitize all inputs
$schoolID = (int)$_POST['school_id'];
$affiliation = (int)$_POST['affiliation'];
$environment = (int)$_POST['environment'];
$totalTeachers = (int)$_POST['total-teachers'];
$paidTeachers = (int)$_POST['paid-teachers'];
$volunteerTeachers = (int)$_POST['volunteer-teachers'];
$grade = (int)$_POST['grade'];
$roomNumber = (int)$_POST['room-number'];
$childrenCount = (int)$_POST['children-count'];
$teacher1Code = trim($_POST['teacher1-code']);
$teacher2Code = isset($_POST['teacher2-code']) ? trim($_POST['teacher2-code']) : null;

try {
    // Get user info from session
    $userID = $_SESSION['user_id'];
    $userName = $_SESSION['fullname']; // Using FullName as userName
    
    // Prepare and execute query
    $sql = "INSERT INTO `basicqualityforms` 
        (`UserID`, `userName`, `SchoolID`, `Belongs`, `Environment`, 
         `TotalTeachers`, `PaidTeachers`, `VolunteerTeachers`, `ClassRoom`, 
         `ClassNo`, `ChildrenCount`, `Teacher1Code`, `Teacher2Code`, `Status`)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("فشل إعداد الاستعلام: " . $conn->error);
    }

    // Bind parameters
    $status = 'مسودة';
    $stmt->bind_param(
        "isiiiiiiiiisss",
        $userID, 
        $userName,
        $schoolID,
        $affiliation,
        $environment,
        $totalTeachers,
        $paidTeachers,
        $volunteerTeachers,
        $grade,
        $roomNumber,
        $childrenCount,
        $teacher1Code,
        $teacher2Code,
        $status
    );

    if (!$stmt->execute()) {
        throw new Exception("فشل التنفيذ: " . $stmt->error);
    }

    // Store form ID in session for next pages
    $_SESSION['current_form_id'] = $stmt->insert_id;
    $_SESSION['school_id'] = $schoolID;
    
    $_SESSION['success'] = "تم الحفظ بنجاح";
    header("Location: teachers.php");
    exit();

} catch (Exception $e) {
    error_log("Error in save_general.php: " . $e->getMessage());
    $_SESSION['error'] = "حدث خطأ في النظام. الرجاء المحاولة لاحقاً. تفاصيل الخطأ: " . $e->getMessage();
    header("Location: general.php");
    exit();
}