<?php
header("Content-Type: text/html; charset=UTF-8");
include('last_db_config.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $full_name = $_POST['full_name'];
    $national_id = $_POST['national_id'];
    $governorate_id = intval($_POST['governorate_id']);
    $admin_id = intval($_POST['admin_id']);

    if (!preg_match('/^\d{14}$/', $national_id)) {
        die("الرقم القومي غير صالح!");
    }

    // 🔍 تحقق مما إذا كان الرقم القومي موجودًا بالفعل
    $check = $conn->prepare("SELECT ID FROM evaluator WHERE NationalID = ?");
    $check->bind_param("s", $national_id);
    $check->execute();
    $check_result = $check->get_result();

    if ($check_result->num_rows > 0) {
        echo "<script>alert('هذا الرقم القومي مسجل بالفعل.'); window.location.href='new_register.php';</script>";
        exit;
    }

    // ✅ إذا لم يكن موجودًا، يتم إدخاله
    $stmt = $conn->prepare("INSERT INTO evaluator(Name, NationalID, GovID, EdaraID) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssii", $full_name, $national_id, $governorate_id, $admin_id);

    if ($stmt->execute()) {
        session_start();
        $_SESSION['evaluator_name'] = $full_name;
        header("Location: new_rows_fail_students.php");
        exit;
    } else {
        echo "<script>alert('حدث خطأ أثناء التسجيل: " . $stmt->error . "'); window.location.href='new_register.php';</script>";
    }
}
?>
