<?php
header('Content-Type: text/html; charset=utf-8');
include('last_db_config.php'); // تأكدي من مسار الاتصال الصحيح بقاعدة البيانات

// استعلام ملخص إجمالي
$summary_query = "
SELECT 
  COUNT(*) AS total_students,
  SUM(CASE WHEN evaluated = 1 THEN 1 ELSE 0 END) AS evaluated_students,
  SUM(CASE WHEN evaluated = 0 THEN 1 ELSE 0 END) AS not_evaluated_students
FROM student
";
$summary_result = mysqli_query($conn, $summary_query);
$summary_data = mysqli_fetch_assoc($summary_result);

// الاستعلام الرئيسي للتقرير التفصيلي
$query = "
SELECT 
  g.GovName AS المحافظة,
  e.EdaraName AS الإدارة,
  sc.SchoolName AS المدرسة,
  
  COUNT(st.StudentID) AS العدد_الفعلي_للطلاب,
  
  SUM(CASE WHEN st.evaluated = 1 THEN 1 ELSE 0 END) AS عدد_المقيمين,
  SUM(CASE WHEN st.evaluated = 0 THEN 1 ELSE 0 END) AS عدد_غير_المقيمين,
  
  SUM(CASE 
    WHEN st.evaluated = 1 AND 
         (IFNULL(tr.Q1,0) + IFNULL(tr.Q2,0) + IFNULL(tr.Q3,0) + IFNULL(tr.Q4,0) + IFNULL(tr.Q5,0) + IFNULL(tr.Q6,0) + IFNULL(tr.Q7,0) + IFNULL(tr.Q8,0) + IFNULL(tr.Q9,0) + IFNULL(tr.Q10,0) + IFNULL(tr.Q11,0) + IFNULL(tr.Q12,0) + IFNULL(tr.Q13,0)) >= 36
    THEN 1 ELSE 0 END) AS عدد_الناجحين,
  
  SUM(CASE 
    WHEN st.evaluated = 1 AND 
         (IFNULL(tr.Q1,0) + IFNULL(tr.Q2,0) + IFNULL(tr.Q3,0) + IFNULL(tr.Q4,0) + IFNULL(tr.Q5,0) + IFNULL(tr.Q6,0) + IFNULL(tr.Q7,0) + IFNULL(tr.Q8,0) + IFNULL(tr.Q9,0) + IFNULL(tr.Q10,0) + IFNULL(tr.Q11,0) + IFNULL(tr.Q12,0) + IFNULL(tr.Q13,0)) > 0 AND
         (IFNULL(tr.Q1,0) + IFNULL(tr.Q2,0) + IFNULL(tr.Q3,0) + IFNULL(tr.Q4,0) + IFNULL(tr.Q5,0) + IFNULL(tr.Q6,0) + IFNULL(tr.Q7,0) + IFNULL(tr.Q8,0) + IFNULL(tr.Q9,0) + IFNULL(tr.Q10,0) + IFNULL(tr.Q11,0) + IFNULL(tr.Q12,0) + IFNULL(tr.Q13,0)) < 36
    THEN 1 ELSE 0 END) AS عدد_الراسبين,
  
  SUM(CASE 
    WHEN st.evaluated = 1 AND
         (IFNULL(tr.Q1,0) + IFNULL(tr.Q2,0) + IFNULL(tr.Q3,0) + IFNULL(tr.Q4,0) + IFNULL(tr.Q5,0) + IFNULL(tr.Q6,0) + IFNULL(tr.Q7,0) + IFNULL(tr.Q8,0) + IFNULL(tr.Q9,0) + IFNULL(tr.Q10,0) + IFNULL(tr.Q11,0) + IFNULL(tr.Q12,0) + IFNULL(tr.Q13,0)) = 0
    THEN 1 ELSE 0 END) AS عدد_الغائبين

FROM student st
LEFT JOIN testresult tr ON st.StudentID = tr.StudentID
JOIN school sc ON st.SchoolID = sc.SchoolID
JOIN edara e ON sc.EdaraID = e.EdaraID
JOIN government g ON e.GovID = g.GovID

GROUP BY g.GovName, e.EdaraName, sc.SchoolName
ORDER BY g.GovName, e.EdaraName, sc.SchoolName
";

$result = mysqli_query($conn, $query);

if (!$result) {
    die("خطأ في استعلام قاعدة البيانات: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8" />
    <title>تقرير تقييم الطلاب</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 20px;
            background-color: #f5f5f5;
        }
        h2, h3 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
            background-color: white;
        }
        th, td {
            border: 1px solid #333;
            padding: 8px;
        }
        th {
            background-color: #009879;
            color: white;
        }
        tbody tr:nth-child(even) {
            background-color: #f3f3f3;
        }
    </style>
</head>
<body>

<h3>
    إجمالي الطلاب الذين تم تقييمهم: <?= $summary_data['evaluated_students'] ?><br>
    إجمالي الطلاب الذين لم يتم تقييمهم: <?= $summary_data['not_evaluated_students'] ?><br>
    إجمالي عدد الطلاب: <?= $summary_data['total_students'] ?>
</h3>

<h2>تقرير تقييم الطلاب لكل مدرسة</h2>

<table>
    <thead>
        <tr>
            <th>المحافظة</th>
            <th>الإدارة</th>
            <th>المدرسة</th>
            <th>العدد الفعلي للطلاب</th>
            <th>عدد الطلاب التي تم تقييمهم</th>
            <th>عدد الطلاب التي لم يتم تقييمهم</th>
            <th>عدد الناجحين</th>
            <th>عدد الراسبين</th>
            <th>عدد الغائبين</th>
        </tr>
    </thead>
    <tbody>
    <?php while ($row = mysqli_fetch_assoc($result)) : ?>
        <tr>
            <td><?= htmlspecialchars($row['المحافظة']) ?></td>
            <td><?= htmlspecialchars($row['الإدارة']) ?></td>
            <td><?= htmlspecialchars($row['المدرسة']) ?></td>
            <td><?= $row['العدد_الفعلي_للطلاب'] ?></td>
            <td><?= $row['عدد_المقيمين'] ?></td>
            <td><?= $row['عدد_غير_المقيمين'] ?></td>
            <td><?= $row['عدد_الناجحين'] ?></td>
            <td><?= $row['عدد_الراسبين'] ?></td>
            <td><?= $row['عدد_الغائبين'] ?></td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

</body>
</html>
